/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoolSetting
implements ISetting {
    private boolean value;
    private boolean defaultValue;

    public BoolSetting(boolean init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BoolSetting(boolean value, boolean def) {
        this.value = value;
        this.defaultValue = def;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean getDefault() {
        return this.defaultValue;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutboolsetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent(this.value ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
    }

    @Override
    public void trigger() {
        this.value = !this.value;
    }
}

